from codeable_detectors.evidences import ComponentEvidence
from codeable_detectors.js.jsDetectors import JSImportLink
from codeable_detectors.utils import extend_lists_in_keyword_args


class JSInstanaLink(JSImportLink):
    def __init__(self):
        super().__init__("@instana/collector")

    def detect_in_context(self, ctx, **kwargs):
        extend_lists_in_keyword_args(kwargs, "link_types", "http2")
        extend_lists_in_keyword_args(kwargs, "technology_types", "instana")
        return super().detect_in_context(ctx, **kwargs)


class JSInstanaComponent(JSImportLink):
    def __init__(self):
        super().__init__("@instana/collector")

    def detect_in_context(self, ctx, **kwargs):
        evidence = super().detect_in_context(ctx, **kwargs)
        if not evidence.has_succeeded():
            return evidence
        return ComponentEvidence(evidence.matches).set_properties(
            detector_name="Instana Agent",
            detector_component_types=["tracingComponent", "externalComponent"],
            detector_link_types="http2",
            detector_technology_types="instana", kwargs=kwargs)
